******macros*****************************;
%macro unplanned_adm(Infile=, outfile=);
data &outfile;
set &INFILE;

/*PLANNED ADMISSIONS ALGORITHM -- VERSION 4.0 */
ARRAY PROC{1:25} MEDPAR_SRGCL_PRCDR_CD1 - MEDPAR_SRGCL_PRCDR_CD25;
ARRAY PRCCS{1:25} $3.;
DO I=1 TO 25;
  PRCCS[I]=PUT(PROC[I],$CCS10PROC.); 
END;

* Categorize the CCS Diagnosis Claims for the potential readmissions;
LENGTH DXCCS $3.;
DXCCS=PUT(MEDPAR_DGNS_CD1,$CCS10CD.);

* Create a variable for the AHRQ CCS acute diagnosis based exclusions for planned;
  IF 1<=DXCCS<=5 | DXCCS IN ('7','8','9','54','55','60','61','63','76','77','78') |
     82<=DXCCS<=85 | DXCCS='87' | 89<=DXCCS<=93 | DXCCS IN ('99','102','104','107',
     '109','112','116','118','120') | 122<=DXCCS<=131 | DXCCS IN ('135','137','139',
     '140','142','145','146','148','153','154','157','159','165','168','172','197',
     '198') | 225<=DXCCS<=230 | 232<=DXCCS<=235 | 237<=DXCCS<=247 | 249<=DXCCS<=253 | 
     DXCCS='259' | 650<=DXCCS<=653 | DXCCS IN ('656','658','660','661','662','663','670')
     OR
     (DXCCS IN ('105','106') AND DIAG1 IN ('I442','I4430','I440','I441','I4469','I444',
	 'I445','I4460','I447','I4510','I4430','I4439','I454','I452','I453','I455','I456',
	 'I4581','I459','I479','R001','I498','I499','I4949','R000'))
     OR
     (DXCCS='97' AND DIAG1 IN ('A3681','A3950','A3953','A3951','A3952','B3320',
     'B3323','B3321','B3322','B376','B394','I32','I39','B395','B399','B5881',
     'I010','I011','I012','I018','I019','I020','I090','I099','I0989','I32',
     'I309','I300','I308','I330','I339','I41','I409','I400','I401',
     'I408','I312','I310','I311','I314','I514'))
     OR
     (DXCCS='108' AND DIAG1 IN ('I0981','I509','I501','I5020','I5021','I5023',
     'I5030','I5031','I5033','I5040','I5041','I5043','I509')) 
     OR
     (DXCCS='100' AND DIAG1 IN ('I2109','I2111','I2119','I2129','I213','I214'))
     OR
     (DXCCS='149' AND DIAG1 IN ('K8000','K8001','K8042','K8043','K8062','K8063',
     'K8066','K8067','K810','K812','K830')) 
     OR
     (DXCCS='152' AND DIAG1='K859') 
    THEN EXCLDX=1;
    ELSE EXCLDX=0;

* CREATE ALWAYS PLANNED PROCEDURE VARIABLE;
PLANNED_1=0; PLANNED_2=0;
DO I=1 TO 25;
  IF PRCCS[I] IN ('64','105','176','134','135') THEN PLANNED_2=1;
  
    IF PRCCS[I] IN ('1','3','5','9','10','12','33','36','38','40','43','44','45',
	  '49','51','52','53','55','56','59','66','67','74','78','79','84','85','86',
	  '99','104','106','107','109','112','113','114','119','120','124','129','132',
	  '142','152','153','154','158','159','166','167','172','175') 
	   OR
	   PROC[I] IN ('GZB4ZZZ','GZB0ZZZ','GZB1ZZZ','GZB2ZZZ','GZB3ZZZ',
	   '0B110F4','0B110Z4','0B113F4','0B113Z4','0B114F4','0B114Z4','0CTS0ZZ',
	   '0CTS4ZZ','0CTS7ZZ','0CTS8ZZ','0GTG0ZZ','0GTG4ZZ','0GTH0ZZ','0GTH4ZZ',
	   '0GTK0ZZ','0GTK4ZZ','0WB60ZZ','0WB63ZZ','0WB64ZZ','0WB6XZZ','0BW10FZ',
	   '0BW13FZ','0BW14FZ','0WB6XZ2','0WQ6XZ2','0B5N0ZZ','0B5N3ZZ','0B5N4ZZ',
	   '0B5P0ZZ','0B5P3ZZ','0B5P4ZZ','0CBS0ZZ','0CBS3ZZ','0CBS4ZZ','0CBS7ZZ',
	   '0CBS8ZZ','0T9030Z','0T9040Z','0T9130Z','0T9140Z','0TC03ZZ','0TC04ZZ',
	   '0TC13ZZ','0TC14ZZ','0TF33ZZ','0TF34ZZ','0TF43ZZ','0TF44ZZ','04CK0ZZ',
	   '04CK3ZZ','04CK4ZZ','04CL0ZZ','04CL3ZZ','04CL4ZZ','04CM0ZZ','04CM3ZZ',
	   '04CM4ZZ','04CN0ZZ','04CN3ZZ','04CN4ZZ','04CP0ZZ','04CP3ZZ','04CP4ZZ',
	   '04CQ0ZZ','04CQ3ZZ','04CQ4ZZ','04CR0ZZ','04CR3ZZ','04CR4ZZ','04CS0ZZ',
	   '04CS3ZZ','04CS4ZZ','04CT0ZZ','04CT3ZZ','04CT4ZZ','04CU0ZZ','04CU3ZZ',
	   '04CU4ZZ','04CV0ZZ','04CV3ZZ','04CV4ZZ','04CW0ZZ','04CW3ZZ','04CW4ZZ',
	   '04CY0ZZ','04CY3ZZ','04CY4ZZ')
    THEN PLANNED_1=1;
END;
PLANNED=(PLANNED_2=1) | (DXCCS IN ('45', '194', '196', '254')) |
		(PLANNED_1=1 AND EXCLDX=0);
run;
%mend;

**macro for selecting procedures in inpatient planned admission claims;  
%macro inpat(yr=, out=);
  proc sql;
      create table inpatient_temp as select * from mpar&yr..Medpar_20&yr._bb as a left join den&yr..Denoma_20&yr (keep=y&yr.hicno y&yr.sex y&yr.dob y&yr.race y&yr.age) as b on a.hicno=b.y&yr.hicno;
  quit;

  data inpatient;
      length medpar_clm_id $50;
      set inpatient_temp;
      medpar_clm_id="&yr"||"_"||trim(left(_n_));
  run;

  %unplanned_adm(Infile=inpatient, outfile=post);

  data inpatient_planned; set post; where planned=1; run;

  %do i=1 %to 25 ;
    data temp;
	  set inpatient_planned(KEEP=medpar_clm_id hicno y&yr.sex y&yr.race y&yr.dob y&yr.age prvid medpar_admsn_dt medpar_dschrg_dt medpar_srgcl_prcdr_CD&i medpar_srgcl_prcdr_prfrm_dt&i);
	  where missing(medpar_srgcl_prcdr_CD&i)^=1;  
      admsn_dt=datejul(medpar_admsn_dt);
	  dsch_dt=datejul(medpar_dschrg_dt);
      rename medpar_srgcl_prcdr_CD&i=prcdr
	         medpar_srgcl_prcdr_prfrm_dt&i=prcdt
             y&yr.sex=sex
             y&yr.race=race
             y&yr.dob=dob
			 y&yr.age=age
      ;
	run;
    %if &i=1 %then %str(data ttt; set temp; run;);
    %else %str(data ttt; set ttt temp; run;);
    proc datasets nodetails; delete temp ; run;
  %end;

  proc sort data=ttt nodupkey out=&out; by medpar_clm_id prcdr ; run;
  data &out; set &out; year=&yr; run;
  proc datasets nodetails; delete inpatient_temp  inpatient post inpatient_planned ttt; run;
%mend;

%macro INPT_SELECT_full(in=, HOSPs=, out=);
   %let i=1;
   %let hosp=%scan(&HOSPs,&i,' ');
   %do  %until(&hosp= );
      data temp;
	   set &in;
	   where prvid="&hosp";
	   id=_n_;
	  run;

	  proc sort; by cat; run;

      *select first 100 cases which is proportional to the total number of cases at the hospital in each procedure category;
      proc surveyselect data=temp n=100 out=first seed=12345;
        strata cat / alloc=prop ;
      run;

	  *select 50 cases in the rest sample;
	  proc sql;
	    create table temp1 as select * from temp where id not in (select id from first);
	  quit;
      
      proc surveyselect data=temp1 n=50 out=second seed=6789;
        strata cat / alloc=prop ;
      run;

      data first; set first; part=1;
      data second; set second; part=2;
	  data temp2;
	     set first second;
		 keep medpar_clm_id year hicno sex race dob prvid admsn_dt dsch_dt prcdr cc_proc ccs cat part proc_dt cc_label proc_label;
	  run;

      %if &i=1 %then %str(data &out; set temp2; run;); %else %str(data &out; set &out temp2; run;); 
      proc datasets nodetails; delete temp temp1 temp2 first second ; run;

	  DM 'LOG; CLEAR';
      DM 'OUTPUT; CLEAR';

      %let i=%eval(&i+1);
      %let hosp=%scan(&HOSPs,&i,' ');
   %end;
%mend;
